#include "WC_WaveShape.h"

#include "ArgList.h"

WC_WaveShape::WC_WaveShape() {
	mPrefWidth = 1;
	mPrefHeight = 1;
}


#define _assignOrig( field )  field##Orig = field;



void WC_WaveShape::Assign( const ArgList& inArgs, ExpressionDict& ioDict ) {
	UtilStr str;

	
	// Extract, compile, and link in order
	mA_Var.Compile( inArgs, 'A', ioDict );		mA_Var.Evaluate();		// The "a"'s are done once per load
	mB_Var.Compile( inArgs, 'B', ioDict );
	mC_Var.Compile( inArgs, 'C', ioDict );
	mD_Var.Compile( inArgs, 'D', ioDict );
	
	
	inArgs.GetArg( 'X', str );	mX.Compile( str, ioDict );
	inArgs.GetArg( 'Y', str );	mY.Compile( str, ioDict );
	inArgs.GetArg( 'Z', str );	mZ.Compile( str, ioDict );
		
	// Set some basic params
	mBlurVal			= inArgs.GetArg( 'BlrB' );
	mNumBlurs			= inArgs.GetArg( 'Blrs' );
	mSampleDelay		= inArgs.GetArg( 'Resn' );
	mConnectSamples		= inArgs.GetArg( 'ConL' );
	mConnectBins		= inArgs.GetArg( 'ConB' );
	mConnectFirstLast	= inArgs.GetArg( 'ConB' ) > 1;
	mCanIncreaseScale	= inArgs.GetArg( 'ScSz' );
	
	// Change sample expiration/duration from secs to ticks
	mSampleDuration		= 1000.0 * inArgs.GetFloat( 'Durn' );

	// Know the preferred X to Y ratio
	mConfigScale		= mXYScale = inArgs.GetArg( 'Scal' );
	mPrefWidth			= inArgs.GetArg( 'widt' );
	mPrefHeight			= inArgs.GetArg( 'heig' );
	mPerspectiveInt		= inArgs.GetFloat( 'Pers' );
	mFalloff			= inArgs.GetFloat( 'Fall' );

	
	// Help make up for the fact that winamp and macamp give us differend data
	#if EG_WIN
	mFalloff *= 0.82;
	#endif	

	// How many steps of s from 0 to 1
	mNum_S_Steps = inArgs.GetArg( 'Stps' );
	if ( mNum_S_Steps < 1 )
		mNum_S_Steps = NUM_SAMPLE_BINS;
	if ( mNum_S_Steps > NUM_SAMPLE_BINS )
		mNum_S_Steps = NUM_SAMPLE_BINS;

	// Read and compile the camera xyz pos, dir, and angle exprs
	inArgs.GetArg( 'CamX', str );	mCamX.Compile( str, ioDict );
	inArgs.GetArg( 'CamY', str );	mCamY.Compile( str, ioDict );
	inArgs.GetArg( 'CamZ', str );	mCamZ.Compile( str, ioDict );
	inArgs.GetArg( 'CmLX', str );	mCamLX.Compile( str, ioDict );
	inArgs.GetArg( 'CmLY', str );	mCamLY.Compile( str, ioDict );
	inArgs.GetArg( 'CmLZ', str );	mCamLZ.Compile( str, ioDict );
	inArgs.GetArg( 'CUpX', str );	mCamUpX.Compile( str, ioDict );
	inArgs.GetArg( 'CUpY', str );	mCamUpY.Compile( str, ioDict );
	inArgs.GetArg( 'CUpZ', str );	mCamUpZ.Compile( str, ioDict );
	
	inArgs.GetArg( 'LWdt', str );
	if ( str.length() == 0 )
		str.Assign( "1" );
	mLineWidth.Compile( str, ioDict );
	
	// Read and compile color expressions
	inArgs.GetArg( 'R', str );	mR.Compile( str, ioDict );
	inArgs.GetArg( 'G', str );	mG.Compile( str, ioDict );
	inArgs.GetArg( 'B', str );	mB.Compile( str, ioDict );
	if ( inArgs.ArgExists( 'LvlR' ) ) {
		inArgs.GetArg( 'LvlR', str ); mLvlR.Compile( str, ioDict );
		inArgs.GetArg( 'LvlG', str ); mLvlG.Compile( str, ioDict );
		inArgs.GetArg( 'LvlB', str ); mLvlB.Compile( str, ioDict ); }
	else {
		mLvlR.Assign( mR );
		mLvlG.Assign( mG );
		mLvlB.Assign( mB );		
	}
	
	inArgs.GetArg( 'BckR', str );	mBackR.Compile( str, ioDict );
	inArgs.GetArg( 'BckG', str );	mBackG.Compile( str, ioDict );
	inArgs.GetArg( 'BckB', str );	mBackB.Compile( str, ioDict );

	mX_Dep_S = mX.IsDependent( "s" ) || mX.IsDependent( "d" );
	mY_Dep_S = mY.IsDependent( "s" ) || mY.IsDependent( "d" );
	mZ_Dep_S = mZ.IsDependent( "s" ) || mZ.IsDependent( "d" );

	mR_Dep_S = mR.IsDependent( "s" ) || mR.IsDependent( "d" );
	mG_Dep_S = mG.IsDependent( "s" ) || mG.IsDependent( "d" );
	mB_Dep_S = mB.IsDependent( "s" ) || mB.IsDependent( "d" );
	
	// Make copies of the original values
	_assignOrig( mSampleDuration )
	_assignOrig( mSampleDelay )
	_assignOrig( mFalloff )
	_assignOrig( mNumBlurs )
	_assignOrig( mBlurVal )
	_assignOrig( mPerspectiveInt )
	_assignOrig( mXYScale )
	_assignOrig( mNum_S_Steps )
	_assignOrig( mConnectBins )
	_assignOrig( mConnectSamples )
	_assignOrig( mConnectFirstLast )
}




void WC_WaveShape::SetScaleToFit( long inWidth, long inHeight ) {
	float s1, s2;
			
	s1 = mConfigScale * inWidth / mPrefWidth;
	s2 = mConfigScale * inHeight / mPrefHeight; 
	if ( s2 < s1 )
		s1 = s2;
	if ( ! mCanIncreaseScale && s1 > mConfigScale )
		mXYScaleOrig = mConfigScale;
	else
		mXYScaleOrig = s1;
		
	mXYScale = mXYScaleOrig;
}


void WC_WaveShape::SetupTransition( WC_WaveShape* inDest, float* inTLink ) {

	mX.Weight( inDest -> mX, inTLink );
	mY.Weight( inDest -> mY, inTLink );
	mZ.Weight( inDest -> mZ, inTLink );
	
	mCamX.Weight( inDest -> mCamX, inTLink );
	mCamY.Weight( inDest -> mCamY, inTLink );	
	mCamZ.Weight( inDest -> mCamZ, inTLink );
	
	mCamLX.Weight( inDest -> mCamLX, inTLink );
	mCamLY.Weight( inDest -> mCamLY, inTLink );
	mCamLZ.Weight( inDest -> mCamLZ, inTLink );

	mCamUpX.Weight( inDest -> mCamUpX, inTLink );
	mCamUpY.Weight( inDest -> mCamUpY, inTLink );
	mCamUpZ.Weight( inDest -> mCamUpZ, inTLink );
	
	mR.Weight( inDest -> mR, inTLink );
	mG.Weight( inDest -> mG, inTLink );
	mB.Weight( inDest -> mB, inTLink );
	
	mLvlR.Weight( inDest -> mLvlR, inTLink );
	mLvlG.Weight( inDest -> mLvlG, inTLink );
	mLvlB.Weight( inDest -> mLvlB, inTLink );

	mBackR.Weight( inDest -> mBackR, inTLink );
	mBackG.Weight( inDest -> mBackG, inTLink );
	mBackB.Weight( inDest -> mBackB, inTLink );
		
	mX_Dep_S = mX_Dep_S || inDest -> mX_Dep_S;
	mY_Dep_S = mY_Dep_S || inDest -> mY_Dep_S;
	mZ_Dep_S = mZ_Dep_S || inDest -> mZ_Dep_S;

	mR_Dep_S = mR_Dep_S || inDest -> mR_Dep_S;
	mG_Dep_S = mG_Dep_S || inDest -> mG_Dep_S;
	mB_Dep_S = mB_Dep_S || inDest -> mB_Dep_S;
	
	mLineWidth.Weight( inDest -> mLineWidth, inTLink );
	
}



#define __weightFLT( field ) field = ( inW * ( (float) field##Orig ) + w1 * ( (float) inDest -> field ) );
#define __weightINT( field ) field = ( 0.5 + inW * ( (float) field##Orig ) + w1 * ( (float) inDest -> field ) );
#define __weightBOL( field ) field = .5 < ( inW * ( field##Orig ? 1.0 : 0.0 ) + w1 * ( inDest -> field ? 1.0 : 0.0 ) );

void WC_WaveShape::SetupFrame( WC_WaveShape* inDest, float inW ) {
	float w1 = 1.0 - inW;
		
	__weightINT( mSampleDuration )
	__weightINT( mSampleDelay )
	__weightFLT( mFalloff )
	__weightINT( mNumBlurs )
	__weightINT( mBlurVal )
	__weightFLT( mPerspectiveInt )
	__weightFLT( mXYScale )
	__weightINT( mNum_S_Steps )
	__weightBOL( mConnectBins )
	__weightBOL( mConnectSamples )
	__weightBOL( mConnectFirstLast )
}


